<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @filesource
*/ /** */

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ 
class API {
	protected $CI;
	var $public_key = WEBSERVICE_PUBLIC_KEY;
	var $private_key = WEBSERVICE_PRIVATE_KEY;
	
	var $date; //if left unset, will be set when call() is called
	var $http_method = 'GET'; //GET, POST, etc.
	var $resource; //the URL to send to: e.g., /direct/send

	var $data = array(); //vars to send via post
	var $files_to_send = array(); //separate array of files to send
	var $http_status;
	var $raw_output;
	var $format = 'json';
	var $profiler_log = array(); //
	
	//vars preceded by underscore are for internal use
	//don't call these!  call the method with the same name instead.
	protected $_authorization_header; 
	protected $_boundary;
	protected $_content_type = 'application/x-www-form-urlencoded'; //multipart/form-data, etc.	
	protected $_headers;
	protected $_formatted_output;
	protected $_output_as_array;
	protected $_output;
	protected $_target_url;
	

	public function __construct(){
		$this->CI = get_instance();
		$this->CI->load->helper(array('array', 'date', 'string', 'url'));
	}	
	
	public function call($resource = null, $data = null, $http_method = null){
		if(!is_null($resource)) $this->resource = $resource;
		if(!is_null($data))$this->data = array_merge($this->data, $data);
		if(!is_null($http_method)) $this->http_method = $http_method;
		
		//verify that any files that we're sending are being sent correctly
		if(!empty($this->files_to_send) && $this->http_method != 'POST'){
			$this->CI->error->warning('Files must be sent via POST. Files ('.array_to_human_readable_list(collect('filename', $this->files_to_send)).') will not be sent to '.$this->target_url());	
		}	
	
		if(!isset($this->date)) $this->date = now();
		$this->resource = strip_from_end('/', $this->resource);
		
		$this->format = strtolower($this->format);
		if($this->format != 'xml' && !string_contains('/format/', $this->resource))
			$this->resource .= '/format/'.$this->format;	
		
		if($this->CI->output->profiler_is_enabled()){
			$this->CI->benchmark->mark('service_call_start');			
		}
		
# TODO -- ADD SOME VALIDATION OF DATA, FIGURE OUT IF YOU HAVE POST DATA, TRIGGER WARNING 
		$headers = $this->headers();
		if(empty($headers) || !is_array($headers)){
			trigger_error("I can't perform the service call without valid headers", E_USER_WARNING);
			return false;
		}  
		
        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->target_url());
		if($this->http_method == 'POST'){
	        curl_setopt($ch, CURLOPT_POST,1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $this->data_for_post());
		}
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER,$this->headers());
		$this->raw_output = curl_exec($ch);
		if($this->raw_output === FALSE){
			trigger_error(curl_error($ch), E_USER_ERROR);
			$this->format_errors[] = 'cURL call failed';
		}
		$this->http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);		
		curl_close($ch);
		
		//trigger a warning if the call didn't work.  note that 403 is an application attempting to do something they're unauthorized; developers debugging unexpected behavior may want to show the error for 403s
		
		if($this->http_status != 200 && $this->http_status != '403'){ 
			get_instance()->error->warning(implode_nonempty('; ', array('Error '.$this->http_status.' while accessing '.$this->target_url().' via '.$this->http_method, $this->message())));
		}
		
		$this->raw_output = trim($this->raw_output);
		if(empty($this->raw_output)){
			$this->CI->error->warning('No output for API call: '.$this->target_url().' with data '.$this->CI->error->describe($this->data));	
			$this->format_errors[] = 'No output';
		}
		
		if($this->format == 'xml'){
			//check xml for formatting errors
			libxml_use_internal_errors(true);
			$xml = simplexml_load_string(trim($this->raw_output));
			if(empty($xml) && !empty($this->raw_output)){ 
				$this->format_errors = collect('message', libxml_get_errors()); 
				foreach($this->format_errors as $error_message){
					$this->CI->error->warning('XML parse error for API call '.$this->target_url().': '.$error_message.'.  Data for API call: '.$this->CI->error->describe($this->data));	
				}
			}
			libxml_use_internal_errors(false);
		}
		
		if($this->format = 'json'){
			$json = json_decode(trim($this->raw_output));
			if(json_last_error() != JSON_ERROR_NONE){
				
				$error_message = json_last_error_msg();
				$this->CI->error->warning('JSON parse error for API call '.$this->target_url().': '.$error_message.'.  Data for API call: '.$this->CI->error->describe($this->data));	
				$this->format_errors = array($error_message);
			}	
		}
		
		$this->add_call_to_profile_log();	
		return ($this->http_status == '200');
	}
	
	/**
	* Restores class variables to their default values.
	* To preserve a value, add it to the $vars_to_preserve array in this method.
	*/
	function clear(){
		$vars_to_preserve = array('CI', 'public_key', 'private_key', 'profiler_log');	
		foreach(get_class_vars(get_class($this)) as $var => $value){
			if(!in_array($var, $vars_to_preserve)){
				$this->$var = $value; 
			}
		}	
	}
	
	//output formatted for human legibility: i.e., whitespace added
	public function formatted_output(){
		if(isset($this->raw_output) && !isset($this->_formatted_output)){
			if(empty($this->format_errors) && $this->format == 'xml'){
				//format the output
				$dom = new DOMDocument;		
				$dom->preserveWhiteSpace = FALSE;
				$dom->loadXML($this->raw_output);
				$dom->formatOutput = TRUE;
				$this->_formatted_output = $dom->saveXml();	
			}else{
				$this->_formatted_output = json_encode($this->output_as_array(), JSON_PRETTY_PRINT);
			}
		}
		return $this->_formatted_output;
	}			

	public function message(){
		return element('message', $this->output_as_array());
	}	
	
	//returns the output formatted as an object
	public function output(){
		if(isset($this->raw_output) && !isset($this->_output)){
			if(empty($this->format_errors)){				
				if($this->format == 'xml'){				
					$this->_output = json_decode(json_encode(simplexml_load_string(trim($this->raw_output))));
				}elseif($this->format == 'json'){
					$this->_output = json_decode(trim($this->raw_output));
				}
			}else{
				$this->_output = (object)array();
			}	
		}
		return $this->_output;
	}
	
	//returns the output formatted as an array
	public function output_as_array(){
		if(isset($this->raw_output) && !isset($this->_output_as_array)){
			if(empty($this->format_errors)){
				if($this->format == 'xml'){				
					$this->_output_as_array = json_decode(json_encode(simplexml_load_string(trim($this->raw_output))), TRUE);
				}elseif($this->format == 'json'){
					$this->_output_as_array = json_decode(trim($this->raw_output), TRUE);
				}
			}else{
				$this->_output_as_array = array();
			}	
		}
		return $this->_output_as_array;
	}
	
	//returns the request id for the previous call
	public function request_id(){
		return element('request_id', $this->output_as_array());
	}
	
///////////////////////////////
// PROTECTED HELPER METHODS
////////////////////////////////
	protected function authorization_header(){
		if(!isset($this->_authorization_header)){
			$this->http_method = strtoupper($this->http_method);
			$known_http_methods = array('GET', 'POST', 'PUT', 'DELETE');
			if(empty($this->http_method) || !in_array($this->http_method, $known_http_methods)){
				trigger_error('I expected a known http_method, but you gave me '.$this->http_method ); 
				return false;
			}			
			if(empty($this->date)) { trigger_error("I can't create an authorization header without a date"); return false; }
			if(empty($this->content_type())) { trigger_error("I can't create an authorization header without a content_type"); return false; }
			if(empty($this->resource)) { trigger_error("I can't create an authorization header without a resource"); return false; }
			
			if(empty($this->public_key)) { trigger_error("I can't create an authorization header without a public key"); return false; }
			if(empty($this->private_key)) { trigger_error("I can't create an authorization header without a private key"); return false; }  		
					
			$components = array($this->http_method,
								$this->date,
								strip_from_end('; boundary='.$this->boundary(), $this->content_type()),
								$this->resource_with_query_string());
			
			$this->_authorization_header =  'DAAS ' . $this->public_key . ':' . base64_encode(hash_hmac('sha256', implode("\n", $components), $this->private_key));
		}
		return $this->_authorization_header;
	}
	
	protected function boundary(){
		if(!isset($this->_boundary)){
			return hash('sha256',(time()));
		}
		return $this->_boundary;
	}	
	
	protected function content_type(){
		if($this->http_method == 'POST' && !empty($this->files_to_send)){
			return 'multipart/form-data; boundary='.$this->boundary();
		}
		return $this->_content_type;
	}	
	
	protected function data_for_post(){		
		//if there aren't any files, we can piece together the data pretty simply
		if(empty($this->files_to_send) || !string_begins_with('multipart/form-data', $this->content_type())) return raw_http_build_query($this->data);
		
		//if there are files, we need to do a more complicated processing of the data
		$post = '';
		$post .= '--'.$this->boundary()."\r\n";
		foreach($this->data as $name => $value) {
			$post .= 'Content-Disposition: form-data; name="'.$name.'"'."\r\n\r\n";
			$post .= $value."\r\n";
			$post .= '--'.$this->boundary()."\r\n";
		}
		$i = 0;
		foreach($this->files_to_send as $key => $file) {
			$post .= 'Content-Disposition: form-data; name="'.$key.'"; filename="'.$file['filename'].'"'."\r\n";
			$post .= 'Content-Type: application/octet-stream'."\r\n";
			$post .= 'Content-Transfer-Encoding: binary'."\r\n\r\n";
			$post .= $file['binary_string']."\r\n";
			if($i === count($this->files_to_send)) { $post .= '--'.$this->boundary()."--\r\n"; } else { $post .= '--'.$this->boundary()."\r\n"; }
			$i++;
		}
		
		return $post;
	}
	
# TODO - ADD OPTIONAL CONTENT MD5 HEADER	
	protected function headers(){
		if(!isset($this->_headers)){	
			$authorization_header = $this->authorization_header();
			if(empty($authorization_header)){
				trigger_error("I can't generate headers without a valid authorization header", E_USER_WARNING);
				return false;
			}
		
			$this->_headers = array( 'Authorization: '.$authorization_header,
									 'Date: '.$this->date,
									 'Content-Type: '.$this->content_type());
		}
		return $this->_headers;				  
	}
	
	protected function resource_with_query_string(){
		return strip_from_beginning(WEBSERVICE_URL, $this->target_url());
	}
	
	protected function target_url(){
		if(!isset($this->_target_url)){
			//MG, resist the urge to use site_url(), you're accessing a different site, it will only cause sorrow and woe. - MG  
			if(!empty($this->resource) && !string_begins_with('/', $this->resource)) $this->resource = '/'.$this->resource;	 		
			$this->_target_url = WEBSERVICE_URL . $this->resource;
			if($this->http_method == 'GET' && !empty($this->data)){
				$this->_target_url .= '?'.raw_http_build_query($this->data);
			}
		}
		return $this->_target_url;
	}

	protected function add_call_to_profile_log(){		
		//Add this service call to the profiler
		if($this->CI->output->profiler_is_enabled()){
			$this->CI->benchmark->mark('service_call_end');
			$log_entry = array('time' => $this->CI->benchmark->elapsed_time('service_call_start', 'service_call_end'),
							   'http_method' => $this->http_method,
							   'http_status' => $this->http_status,
							   'format' => strtoupper($this->format),
							   'data' => $this->data,
							   'url' => $this->target_url(),
							   'output' => $this->formatted_output() );
							   
			if(!empty($this->format_errors))
				$log_entry['output'] = $this->raw_output;							   
										   
			$backtrace = debug_backtrace();
			$query_backtrace = array();
			foreach($backtrace as $row => &$data){
				unset($data['object']);	//not necessary, just makes it easier to see things when you're debugging
				unset($data['args']);
				if(!isset($data['file'])) $data['file'] = false;
						
				$data['function_for_display'] = $data['function'];
				if(!empty($data['class'])){
					if($data['class'] == 'Entity' &&  $data['file'] != str_replace('/', '\\', APPPATH.'models/entity.php')){
						$data['class'] = ucfirst(strip_from_end('.php', strip_from_beginning(str_replace('/', '\\', APPPATH.'models/'), $data['file'])));
					}					
					$data['function_for_display'] = $data['class'].$data['type'].$data['function'];
				}
				
				$data['short_file'] = '';
				if(is_string($data['file'])){
					$last_slash = strrpos($data['file'], '/');
					$data['short_file'] = '..'.substr($data['file'], $last_slash);
				}
				$query_backtrace[] = $data;
			}	
			
			$files_to_ignore = array( /*BASEPATH.'database/DB_active_rec.php', BASEPATH.'database/original_DB_driver.php', APPPATH.'libraries/Active_record_model.php', APPPATH.'models/entity.php' */ );
			foreach($files_to_ignore as $file_to_ignore) $files_to_ignore[] = str_replace('/', '\\', $file_to_ignore); //windows uses weird slashes just to annoy us
			foreach($backtrace as $row => $data){
				if(!in_array($data['file'], $files_to_ignore) && array_key_exists('file', $data) && array_key_exists('line', $data)){			
					$file = $data['file'];
					$line = $data['line'];
					$short_file = $data['short_file'];
					$function = $data['class'].$data['type'].$data['function'];
					break;
				}
			}
			$log_entry['backtrace'] = array('line' => $line, 'file' => $file, 'short_file' => $short_file, 'backtrace' => $query_backtrace, 'function' => $function); 	
			$this->profiler_log[] = $log_entry;							   
		}	
	}

}
/* End of file Service_Call.php */
/* Location: ./application/libraries/Service_Call.php */